/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_7367;

public final class JsonUtils<T> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TrainerType.Color.class, (Object)new TrainerType.Color.Serializer()).registerTypeAdapter(TrainerType.Color.class, (Object)new TrainerType.Color.Deserializer()).addSerializationExclusionStrategy((ExclusionStrategy)new AnnotationExclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new AnnotationExclusionStrategy()).setPrettyPrinting().disableHtmlEscaping().setLenient().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(String json, Class<T> type) {
        try (BufferedReader rd = new BufferedReader(new StringReader(json));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(class_7367<InputStream> io, Class<T> type) {
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)io.get(), StandardCharsets.UTF_8));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadFromOrThrow(class_7367<InputStream> io, TypeToken<T> type) {
        try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)io.get(), StandardCharsets.UTF_8));){
            Object object = GSON.fromJson((Reader)rd, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String toJson(T obj) {
        return GSON.toJson(obj);
    }

    private JsonUtils() {
    }

    static class AnnotationExclusionStrategy
    implements ExclusionStrategy {
        AnnotationExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(Exclude.class) != null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }
}

